package org.amse.mm;

import org.amse.mm.io.*;
import org.amse.mm.myVirtualBilliards.model.impl.*;
import org.amse.mm.myVirtualBilliards.view.*;
import org.amse.mm.myVirtualBilliards.model.*;

import java.util.*;
import java.awt.event.*;
import java.io.*;

import javax.swing.JOptionPane;

public class Main {
	public static boolean MyIsGameChecked = true;
	
	public static void main(String[] args){

		ITable table = TableHolder.createTable();
		ICue cue = CueHolder.createCue();
		
		ReadFromJar reader = new ReadFromJar(table, "initialize/initial.bll", true);
		reader.init();
		
		PaintTable paintTable = new PaintTable(table, cue);
		MyListener listener = new MyListener(table, cue);
		paintTable.addKeyListener(listener);
			
		Timer timer = new Timer();
		timer.schedule(new MyTask(table, paintTable, listener), 1000, 10);
	}
	
	public static void checkGame(ITable table, PaintTable paintTable){
		if (! table.areBallsMoving()){
			IBall tmpBall = null;
			for(IBall ball : table.balls()){
				if (ball.getColor() == BallColor.WHITE){
					tmpBall = ball;
				}
			}
			
			int result = -1;
			
			if (tmpBall == null){
				result = JOptionPane.showConfirmDialog(paintTable,
						new String[]{"game over", "play again?"}, "You loose ",
						JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
				
			}else{
				if (table.balls().size() == 1){
					result = JOptionPane.showConfirmDialog(paintTable,
							new String[]{"you win!", "play again?"}, 
							"CONGRATULATION", JOptionPane.YES_NO_OPTION,
							JOptionPane.QUESTION_MESSAGE);
				}
			}
			
			if (result == JOptionPane.YES_OPTION){
				paintTable.MyIsModelChanged = false;
				ReadFromJar reader = new ReadFromJar(table, "initialize/initial.bll", true);
				reader.init();
			}else{
				if (result == JOptionPane.NO_OPTION){
					System.exit(0);
				}
			}
		}		
	}

}	

class MyListener extends KeyAdapter{	
	private double myTimeStart;
	private boolean isReleased = true;
	private int myKeyCode;
	private ITable myListenerTable;
	private ICue myListenerCue;
			
	public MyListener(ITable table, ICue cue){
		myListenerTable = table;
		myListenerCue = cue;
	}
	
	public void keyPressed(KeyEvent e){
		myKeyCode = e.getKeyCode();
		if ((myKeyCode == KeyEvent.VK_LEFT) || (myKeyCode == KeyEvent.VK_RIGHT) ||
			(myKeyCode == KeyEvent.VK_DOWN) || (myKeyCode == KeyEvent.VK_UP) ||
			(myKeyCode == KeyEvent.VK_CONTROL)){
			if (isReleased){
				myTimeStart = System.currentTimeMillis();
				isReleased = false;
			}
		}				
	}
	
	public void keyReleased(KeyEvent e){
		double deltaTime = (System.currentTimeMillis() - myTimeStart) / 1000;
		switch (e.getKeyCode()){
			case KeyEvent.VK_LEFT:
				myListenerCue.setAngle(myListenerCue.getAngle() - deltaTime * 0.3);
				break;
			case KeyEvent.VK_UP:
				myListenerCue.setAngle(myListenerCue.getAngle() - deltaTime * 0.9);
				break;
			case KeyEvent.VK_RIGHT:
				myListenerCue.setAngle(myListenerCue.getAngle() + deltaTime * 0.3);
				break;
			case KeyEvent.VK_DOWN:
				myListenerCue.setAngle(myListenerCue.getAngle() + deltaTime * 0.9); 
				break;
			case KeyEvent.VK_CONTROL:
				myListenerCue.setForce(deltaTime * 15);
				myListenerCue.doStrike(myListenerTable);
				myListenerCue.setForce(0);
				break;
		}
		isReleased = true;
	}
	
	public void moveCue(){
		if (! isReleased){
			double tmpTime = System.currentTimeMillis();
			double deltaTime = (tmpTime - myTimeStart) / 1000;
			
			switch(myKeyCode){
				case KeyEvent.VK_LEFT:
					myListenerCue.setAngle(myListenerCue.getAngle() - deltaTime * 0.3);
					myTimeStart = tmpTime;
					break;
				case KeyEvent.VK_UP:
					myListenerCue.setAngle(myListenerCue.getAngle() - deltaTime * 0.9);
					myTimeStart = tmpTime;
					break;
				case KeyEvent.VK_RIGHT:
					myListenerCue.setAngle(myListenerCue.getAngle() + deltaTime * 0.3);
					myTimeStart = tmpTime;
					break;
				case KeyEvent.VK_DOWN:
					myListenerCue.setAngle(myListenerCue.getAngle() + deltaTime * 0.9);
					myTimeStart = tmpTime; 
					break;
				case KeyEvent.VK_CONTROL:	
					myListenerCue.setForce(Math.min((deltaTime),
							5 * (1 + (myListenerTable.getFriction() - 0.05) * 50)));
					break;
			}
		}		
	}
}

class MyTask extends TimerTask {
	private ITable myTaskTable;
	private PaintTable myTaskPaintTable;
	private MyListener myTaskListener;	
	
	public MyTask(ITable table, PaintTable paintTable, MyListener listener){
		myTaskTable = table;
		myTaskPaintTable = paintTable;
		myTaskListener = listener;
	}
	
	public void run() {
		if (Main.MyIsGameChecked){
			Main.checkGame(myTaskTable, myTaskPaintTable);
		}
		myTaskListener.moveCue();
		myTaskTable.doMove(0.1);
		myTaskPaintTable.repaint();
	}
	
}





